/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console;

import filenet.sim.api.IVWSIMScenario;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleActionCommand;
import filenet.sim.toolkit.console.images.VWSIMImageLoader;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMItem;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;

public class VWSIMScenarioNode
extends VWSIMBaseNode {
    private static final ImageIcon nodeIcon16 = VWSIMImageLoader.createImageIcon("scenario_16.gif");
    private VWSIMBaseNode m_parentFolder = null;
    private IVWSIMScenario m_IVWSIMScenario = null;
    private VWScenarioDefinition m_simScenarioDef = null;
    private Date m_checkinDate = null;
    private String m_currentVersionAuthor = null;
    private IVWIDMDocument m_idmDocument = null;
    private Boolean m_bCanViewContent = null;

    public VWSIMScenarioNode(IVWIDMItem aIDMItem, IVWSIMScenario ivwSIMScenario, VWSIMBaseNode parentFolder) {
        super(aIDMItem, 33, VWSIMConsoleActionCommand.ACMD_SCENARIO);
        try {
            this.setIcon16(nodeIcon16);
            this.m_parentFolder = parentFolder;
            this.m_IVWSIMScenario = ivwSIMScenario;
            this.setName(this.m_IVWSIMScenario.getName());
            GregorianCalendar gcl = this.m_IVWSIMScenario.getDateLastModified();
            this.m_checkinDate = gcl.getTime();
            this.m_currentVersionAuthor = this.m_IVWSIMScenario.getLastModifier();
            this.m_idmDocument = this.m_IVWSIMScenario.getIDMDocument();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public TreeNode getParent() {
        return this.m_parentFolder;
    }

    public void setParent(VWSIMBaseNode parentNode) {
        this.m_parentFolder = parentNode;
    }

    public void refresh() {
        try {
            this.m_IVWSIMScenario.refresh();
            GregorianCalendar gcl = this.m_IVWSIMScenario.getDateLastModified();
            this.m_checkinDate = gcl.getTime();
            this.m_currentVersionAuthor = this.m_IVWSIMScenario.getLastModifier();
            this.setName(this.m_IVWSIMScenario.getName());
            this.m_bCanViewContent = new Boolean(this.m_idmDocument.canOpen());
        }
        catch (Exception ex) {
            this.displayMessage(3, ex.getLocalizedMessage());
            VWDebug.logException(ex);
        }
    }

    public TreeNode getRoot() {
        if (this.m_parentFolder != null) {
            return this.m_parentFolder.getRoot();
        }
        return null;
    }

    public IVWSIMScenario getSIMScenario() {
        return this.m_IVWSIMScenario;
    }

    public int validateScenarioDefinition() throws Exception {
        int valResult = 0;
        this.getScenarioDefinition();
        VWScenarioValidationError[] errMsgs = null;
        errMsgs = this.m_simScenarioDef.validate(this.m_vwSession, true, true);
        if (errMsgs != null && errMsgs.length > 0) {
            boolean bHasError = false;
            for (int i = 0; i < errMsgs.length; ++i) {
                int errType = 1;
                if (errMsgs[i].getLevel() == 1) {
                    bHasError = true;
                    errType = 3;
                    valResult = 3;
                } else if (errMsgs[i].getLevel() == 2) {
                    errType = 2;
                    if (valResult != 3) {
                        valResult = 2;
                    }
                }
                this.displayMessage(errType, errMsgs[i].getMessage());
            }
        }
        return valResult;
    }

    public String getRunTimeScenarioXML() {
        StringBuffer aStringBuffer = new StringBuffer();
        try {
            if (this.m_simScenarioDef != null) {
                this.m_simScenarioDef.toRuntimeXML(this.m_vwSession, aStringBuffer);
            }
        }
        catch (Exception ex) {
            this.displayMessage(3, ex.getLocalizedMessage());
            VWDebug.logException(ex);
        }
        return aStringBuffer.toString();
    }

    public Date getCheckinDate() {
        return this.m_checkinDate;
    }

    public String getCurrentVersionAuthor() {
        return this.m_currentVersionAuthor;
    }

    public boolean canViewContent() {
        if (this.m_bCanViewContent == null) {
            this.m_bCanViewContent = new Boolean(this.m_idmDocument.canOpen());
        }
        return this.m_bCanViewContent;
    }

    public VWScenarioDefinition getScenarioDefinition() throws Exception {
        if (this.m_simScenarioDef == null) {
            this.m_simScenarioDef = this.m_IVWSIMScenario.getScenarioDefinition();
        }
        return this.m_simScenarioDef;
    }

    public void deleteScenario() throws Exception {
        this.m_IVWSIMScenario.deleteScenario();
    }

    public void releaseResources() {
        this.m_parentFolder = null;
        this.m_IVWSIMScenario = null;
        this.m_simScenarioDef = null;
        this.m_checkinDate = null;
        this.m_currentVersionAuthor = null;
        this.m_idmDocument = null;
        this.m_bCanViewContent = null;
        super.releaseResources();
    }
}

